;;************************************************************************
;; overlay1.lsp 
;; contains code for graph overlay
;; copyright (c) 1998 by Forrest W. Young
;; modified by carla bann
;;************************************************************************


    (setf *plot-menu-hot-spot* nil)

(defmeth graph-proto :plot-buttons 
    (&key (margin (list 0 (+ 17 (send self :text-descent)) 0 0)) 
          (help t) (color nil) (mouse-mode t) (connect nil) (pop t) (switch nil)
          (new-x t) (new-y t) (new-z nil) (options nil) (equate nil) (savedata nil)
          (normal nil) (density nil) (smooth nil) (curves nil) (zoom t)
          (bins nil) (bin2 nil) (box nil) (bottom-tool-bar nil)
          (iterate nil) (undo nil) (tiles nil) (plot nil) 
          (random nil) (param nil) (hot-spot t))
  (when margin 
        (when bottom-tool-bar
              (setf (select margin 3) (+ 17 (send self :text-descent))))
        (apply #'send self :margin margin))
  (when (= *color-mode* 0) (setf color nil))
  (send self :use-color (not (= *color-mode* 0)))
  (let ((overlay 
         (first (send self :add-overlay 
                      (send vista-graph-overlay-proto :new 
                            :bottom-tool-bar bottom-tool-bar :connect connect
                            :help help :color color :mouse-mode mouse-mode 
                            :new-x new-x :new-y new-y :new-z new-z :pop pop
                            :density density :smooth smooth :normal normal 
                            :bins bins :box box :equate equate :savedata savedata
                            :iterate iterate :undo undo :tiles tiles :zoom zoom
                            :random random :param param :options options
                            :switch switch :hot-spot hot-spot
;following on bottom bar
                            :bin2 bin2 :curves curves :plot plot))))
        (graph self)
        )
    (send self :add-slot 'button-overlay overlay)
    (defmeth self :button-overlay (&optional (objid nil set))
      "Args: (&optional objid) Sets or returns the object id of the button overlay"
      (if set (setf (slot-value 'button-overlay) objid))
      (slot-value 'button-overlay))
    (when (and (or (equal (send graph :slot-value 'proto-name) 
                          (send scatterplot-proto :slot-value 'proto-name))
                   (equal (send graph :slot-value 'proto-name) 
                          (send vista-scatterplot-proto :slot-value 'proto-name)))
               density)
          (send self :make-scatterplot-curves))
    (defmeth self :do-motion (x y)
      (let* ((margin (send self :margin))
             )
        (cond
          ((and (> (second margin) 0) (<= y (second margin)))
           (send self :cursor 'solid-arrow))
          ((and (> (fourth margin) 0)
                (> y (- (send self :canvas-height) (fourth margin))))
           (send self :cursor 'solid-arrow))
          ((and (> (first margin) 0) (<= x (first margin)))
           (send self :cursor 'solid-arrow))
          ((and (> (third margin) 0) 
                (> x (- (send self :canvas-width) (third margin))))
           (send self :cursor 'solid-arrow))
          (t
           (when (not (eq (send self :cursor) (send self :set-mode-cursor)))
                 (send self :cursor) (send self :set-mode-cursor))
           (send self :do-brush-motion x y)))
        overlay))
    overlay))


(defproto vista-graph-overlay-proto 
  '(buttons plot-help color color-mode mouse-mode bins bin2 savedata zoom zoom-state
            normal density curves smooth box new-x new-y new-z pop pop-state 
            iterate undo equate tiles plot random param lefts strings connect
            bottom-tool-bar num-top-buttons  old-canvas-width options switch
            vertical vertical-offset menu-button hot-spot)  
   () graph-overlay-proto)

(defmeth vista-graph-overlay-proto :isnew 
  (&key (help t) (menu-button t) (color nil) (zoom t) (pop t) (mouse-mode t) 
        (new-x t) (new-y t) (new-z nil) 
        (normal nil) (density nil) (smooth nil) (bins nil) (bin2 nil) 
        (switch nil) (options nil)
        (box nil) (iterate nil) (undo nil) (equate nil) 
        (tiles nil) (savedata nil)
        (plot nil) (curves nil) (random nil) (param nil) 
        (connect nil) (bottom-tool-bar nil) (hot-spot t))
  (call-next-method)
  (send self :hot-spot hot-spot)
  (send self :plot-help help)
  (send self :menu-button menu-button)
  (send self :color color)
  (send self :zoom zoom)
  (send self :color-mode *color-mode*)
  (send self :mouse-mode mouse-mode)
  (send self :new-x new-x)
  (send self :new-y new-y)
  (send self :new-z new-z)
  (send self :pop  pop)
  (send self :bins  bins)
  (send self :bin2  bin2)
  (send self :normal normal)
  (send self :density density)
  (send self :smooth smooth)
  (send self :curves curves)
  (send self :box box)
  (send self :iterate iterate)
  (send self :connect connect)
  (send self :undo undo)
  (send self :equate equate) 
  (send self :tiles tiles)
  (send self :options options)
  (send self :switch switch)
  (send self :plot plot)
  (send self :random random)
  (send self :param param)
  (send self :savedata savedata)
  (send self :bottom-tool-bar bottom-tool-bar)
  )

(defmeth vista-graph-overlay-proto :buttons (&optional (list nil set))
"Args: (&optional logical)
Sets or returns which buttons are hilited."
  (if set (setf (slot-value 'buttons) list))
  (slot-value 'buttons))

(defmeth vista-graph-overlay-proto :plot-help (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether plot-help button is to be drawn."
  (if set (setf (slot-value 'plot-help) logical))
  (slot-value 'plot-help))

(defmeth vista-graph-overlay-proto :menu-button (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether menu-button is to be drawn."
  (if set (setf (slot-value 'menu-button) logical))
  (slot-value 'menu-button))

(defmeth vista-graph-overlay-proto :color (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether color button is to be drawn."
  (if set (setf (slot-value 'color) logical))
  (slot-value 'color))

(defmeth vista-graph-overlay-proto :zoom (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether zoom button is to be drawn."
  (if set (setf (slot-value 'zoom) logical))
  (slot-value 'zoom))

(defmeth vista-graph-overlay-proto :zoom-state (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether zoom button is in zoom or zip mode."
  (if set (setf (slot-value 'zoom-state) logical))
  (slot-value 'zoom-state))

(defmeth vista-graph-overlay-proto :color-mode (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether the graph is in color mode."
  (if set (setf (slot-value 'color-mode) logical))
  (slot-value 'color-mode))

(defmeth vista-graph-overlay-proto :mouse-mode (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether mouse-mode button is to be drawn."
  (if set (setf (slot-value 'mouse-mode) logical))
  (slot-value 'mouse-mode))

(defmeth vista-graph-overlay-proto :pop (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether pop button is to be drawn."
  (if set (setf (slot-value 'pop) logical))
  (slot-value 'pop))

(defmeth vista-graph-overlay-proto :pop-state (&optional (logical nil set))
"Args: (&optional logical)
Remembers pop or put state."
  (send (slot-value 'graph) :pop-state logical)
  (if set (setf (slot-value 'pop-state) logical))
  (slot-value 'pop-state))

(defmeth vista-graph-overlay-proto :vertical (&optional (logical nil set))
"Args: (&optional vertical)
Sets or returns whether the button bar is vertical or horizontal."
  (if set (setf (slot-value 'vertical) logical))
  (slot-value 'vertical))

(defmeth vista-graph-overlay-proto :vertical-offset (&optional (logical nil set))
"Args: (&optional vertical)
Sets or returns the value the aligns buttons with top of vertical bar."
  (if set (setf (slot-value 'vertical-offset) logical))
  (slot-value 'vertical-offset))

(defmeth vista-graph-overlay-proto :bins (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether bins button is to be drawn."
  (if set (setf (slot-value 'bins) logical))
  (slot-value 'bins))

(defmeth vista-graph-overlay-proto :bin2 (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether two - + bin buttons are to be drawn."
  (if set (setf (slot-value 'bin2) logical))
  (slot-value 'bin2))

(defmeth vista-graph-overlay-proto :connect (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether the connect button is to be drawn."
  (if set (setf (slot-value 'connect) logical))
  (slot-value 'connect))

(defmeth vista-graph-overlay-proto :normal (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether normal button is to be drawn."
  (if set (setf (slot-value 'normal) logical))
  (slot-value 'normal))

(defmeth vista-graph-overlay-proto :curves (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether curves button is to be drawn."
  (if set (setf (slot-value 'curves) logical))
  (slot-value 'curves))

(defmeth vista-graph-overlay-proto :density (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether density button is to be drawn."
  (if set (setf (slot-value 'density) logical))
  (slot-value 'density))

(defmeth vista-graph-overlay-proto :smooth (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether smooth button is to be drawn."
  (if set (setf (slot-value 'smooth) logical))
  (slot-value 'smooth))

(defmeth vista-graph-overlay-proto :box (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether bins button is to be drawn."
  (if set (setf (slot-value 'box) logical))
  (slot-value 'box))

(defmeth vista-graph-overlay-proto :new-x (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether new-x button is to be drawn."
  (if set (setf (slot-value 'new-x) logical))
  (slot-value 'new-x))

(defmeth vista-graph-overlay-proto :new-y (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether new-y button is to be drawn."
  (if set (setf (slot-value 'new-y) logical))
  (slot-value 'new-y))

(defmeth vista-graph-overlay-proto :new-z (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether new-z button is to be drawn."
  (if set (setf (slot-value 'new-z) logical))
  (slot-value 'new-z))

(defmeth vista-graph-overlay-proto :iterate (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether iterate button is to be drawn."
  (if set (setf (slot-value 'iterate) logical))
  (slot-value 'iterate))

(defmeth vista-graph-overlay-proto :random (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether iterate button is to be drawn."
  (if set (setf (slot-value 'random) logical))
  (slot-value 'random))

(defmeth vista-graph-overlay-proto :param (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether iterate button is to be drawn."
  (if set (setf (slot-value 'param) logical))
  (slot-value 'param))

(defmeth vista-graph-overlay-proto :options (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether options button is to be drawn."
  (if set (setf (slot-value 'options ) logical))
  (slot-value 'options ))

(defmeth vista-graph-overlay-proto :switch (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether switch button is to be drawn."
  (if set (setf (slot-value 'switch ) logical))
  (slot-value 'switch ))

(defmeth vista-graph-overlay-proto :undo (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether undo button is to be drawn."
  (if set (setf (slot-value 'undo) logical))
  (slot-value 'undo))

(defmeth vista-graph-overlay-proto :equate (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether equate button is to be drawn."
  (if set (setf (slot-value 'equate) logical))
  (slot-value 'equate))

(defmeth vista-graph-overlay-proto :tiles (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether tiles button is to be drawn."
  (if set (setf (slot-value 'tiles) logical))
  (slot-value 'tiles))

(defmeth vista-graph-overlay-proto :savedata (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether savedata button is to be drawn."
  (if set (setf (slot-value 'savedata) logical))
  (slot-value 'savedata))

(defmeth vista-graph-overlay-proto :plot (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether plot button is to be drawn."
  (if set (setf (slot-value 'plot) logical))
  (slot-value 'plot))

(defmeth vista-graph-overlay-proto :bottom-tool-bar 
  (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether buttons appear on a bottom tool bar."
  (if set (setf (slot-value 'bottom-tool-bar) logical))
  (slot-value 'bottom-tool-bar))

(defmeth vista-graph-overlay-proto :hot-spot
  (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether hot spot appears on the tool bar."
  (if set (setf (slot-value 'hot-spot) logical))
  (slot-value 'hot-spot))

(defmeth vista-graph-overlay-proto :lefts (&optional (list nil set))
"Args: (&optional list)
Sets or returns left coordinate of each box on the overlay."
  (if set (setf (slot-value 'lefts) list))
  (slot-value 'lefts))

(defmeth vista-graph-overlay-proto :strings (&optional (list nil set))
"Args: (&optional logical)
Sets or returns list of strings for box names."
  (if set (setf (slot-value 'strings) list))
  (slot-value 'strings))

(defmeth vista-graph-overlay-proto :num-top-buttons 
  (&optional (number nil set))
"Args: (&optional number)
Sets or returns number of buttons on top bar used."
  (if set (setf (slot-value 'num-top-buttons) number))
  (slot-value 'num-top-buttons))

(defmeth vista-graph-overlay-proto :old-canvas-width (&optional (number nil set)) ;fwy!
"Args: (&optional number)
Sets or returns old-canvas-width."
  (if set (setf (slot-value 'old-canvas-width) number))
  (slot-value 'old-canvas-width))

(defmeth vista-graph-overlay-proto :draw-pull-down-menu (x y dir) ;dir 0 rt 1 up 2 
  (let* ((graph (slot-value 'graph))
         (in-color (send graph :draw-color)) 
         (paint t)
         (button-color 'black)
         (on-color 'button-on-color)
         (off-color 'button-off-color)
         (draw-color (send graph :draw-color))
         (h (- (second (send graph :size)) 20 (fourth (send graph :margin))))
         (a (+ x 1))
         (vr (send graph :view-rect))
         (b (+ 0 (second vr) y))
         (c 8);8
         (d 8);8
         (coords
          (case dir ; 0=up 1=rt 2=dn 3=lt
            (0 (list (list a (+ b 8)) 
                     (list c 0)        (list (/ c -2) (* -1 d)) (list (/ c -2) d)))
            (1 (list (list a b) 
                     (list c (/ d 2))  (list (- c) (/ d 2))     (list 0 (- d))))
            (2 (list (list a B) 
                     (list c 0)   (list (/ c -2) d)   (list (/ c -2) (* -1 d))))
            (3 (list (list (+ a 8) (+ b 8))
                     (list (* -1 c) (/ d -2)) (list c (/ d -2)         (list 0 d))))))
         )
    (setf a (1- x))
    (setf b (+ -2 (second vr) y))
    (setf c 12)
    (setf d 12)
             
    (send (send self :graph) :draw-color button-color)
    (send (send self :graph) :frame-rect (1+ a) (1+ b) c d)
    (send (send self :graph) :draw-color off-color)
    (send (send self :graph) :paint-rect a b c d)
    (send (send self :graph) :draw-color button-color)
    (send (send self :graph) :frame-rect a b c d)
    
    (send graph :draw-color 'black)
    (send graph :frame-poly coords nil)
    (send graph :draw-color 'red)
    (send graph :paint-poly coords nil) 
    (send graph :draw-color in-color)
    ))
          
(defmeth vista-graph-overlay-proto :pull-down-menu-spots (menu x y)
  (let* ((graph (slot-value 'graph))
         (vr (send graph :view-rect))
         (cr (send graph :content-rect)))
    (send graph :draw-color 'black)
    (send graph :line-width 1)
    (when menu (send  self :draw-pull-down-menu (+ (first vr) (third vr) -13) 4 2))
    (send graph :draw-color 'black)
    (send graph :line-width 1)
    (send graph :line-type 'solid)
    ))

(defmeth vista-graph-overlay-proto :redraw ()
  (let* ((graph (slot-value 'graph))
         (draw-color (send graph :draw-color))
         (color-mode (send self :color-mode))
         (bottom (send self :bottom-tool-bar))
         (cw (send graph :canvas-width))
         (ch (send graph :canvas-height))
         (i 0)
         (topy 3)
         (height 10)
         (gap 2)
         (td (send graph :text-descent))
         (bottom-of-top (- (second (send graph :margin)) 3))
         (top-of-bottom (- (send graph :canvas-height) 18))
         (bottom-margin (- (send graph :canvas-height) 3 
                           (fourth (send graph :margin))))
         )
    (when (not color-mode) (send graph :use-color nil))
    (when (or (not (send self :old-canvas-width));fwy!
              (/= (send self :old-canvas-width) ;fwy!
                  (send graph :canvas-width)));fwy!
          (send self :old-canvas-width (send graph :canvas-width));fwy!
          (send self :lefts nil));fwy!
    (when (not (send self :lefts)) (send self :setup-redraw))
    (if (and color-mode (send *vista* :background-color))
        (send graph :draw-color 'toolbar-background)
        (send graph :draw-color 'white))
    (send graph :paint-rect 0 0 ;;;;;;;;;;;;;;;;;;;;;;;;;;
          (send graph :canvas-width) bottom-of-top);;;;;;;
    (send graph :draw-color draw-color)
    ;(send graph :draw-line 0 0 cw 0)
    (send graph :draw-line 0 bottom-of-top ;;;;;;;;;;;;;;;
          (send graph :canvas-width) bottom-of-top);;;;;;;
;general buttons used by all plots
    (when (send self :plot-help) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :color) 
          (send self :draw-button (send self :color-mode) i) ;use-color
          (setf i (1+ i)))
    (when (send self :mouse-mode) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :pop) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :zoom) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :options) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :switch) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :new-x) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :new-y) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :new-z) (send self :draw-button nil i) 
          (setf i (1+ i)))
;specific buttons
    (when (send self :box) 
          (send self :draw-button (send graph :show-box) i)
          (setf i (1+ i)))
    (when (send self :iterate) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :random) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :param) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :undo) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :equate) 
          (send self :draw-button (send graph :equate) i)
          (setf i (1+ i)))
    (when (send self :tiles) (send self :draw-button nil i)
          (setf i (1+ i)))
    (when (send self :bins) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :smooth) 
          (send self :draw-button (send graph :show-smooth) i)
          (setf i (1+ i)))
    (when (send self :normal) 
          (send self :draw-button (send graph :show-normal) i)
          (setf i (1+ i)))
    (when (send self :density) 
          (send self :draw-button (send graph :show-density) i)
          (setf i (1+ i)))
    (when (send self :connect) (send self :draw-button nil i)
          (setf i (1+ i)))
    
;following buttons appear on bottom bar
    (when bottom
          (if (and color-mode (send *vista* :background-color))
              (send graph :draw-color 'toolbar-background)
              (send graph :draw-color 'white))
          (send graph :paint-rect 0 top-of-bottom 
                (send graph :canvas-width) (send graph :canvas-height))
          (send graph :draw-color draw-color)
          (send graph :draw-line 0 top-of-bottom 
                (send graph :canvas-width) top-of-bottom)
          )
    (when (send self :bin2) 
          (send self :draw-button nil i :plus-minus nil :bottom t) 
          (setf i (1+ i))
          (send self :draw-button nil i :plus-minus t :bottom t) 
          (setf i (1+ i)))
    (when (send self :curves) 
          (send self :draw-button (send graph :show-density) i :bottom t) 
          (setf i (1+ i)))
    (when (send self :plot) (send self :draw-button nil i :bottom t) 
          (setf i (1+ i)))
    (when (send self :savedata) (send self :draw-button nil i :bottom t) 
          (setf i (1+ i)))    
    (when (and *plot-menu-hot-spot* (send self :hot-spot))
          (send self :pull-down-menu-spots t (send self :new-x) (send self :new-y)) )
    ))

;here's another approach to it (from class)

(defmeth vista-graph-overlay-proto :setup-redraw ()
  (let* ((string-top (list "Help" "Color" "Mouse" 
                           (if (send self :pop-state) "Put" "Pop") 
                           (if (send self :zoom-state) "Restore" "Zoom")
                           "Options" "Switch" "X" "Y" "Z" "Box"
                           "Iter" "Undo" "Equate" "Fill" "NewBins" 
                           "Smooth" "Normal" "Curves" "Connect" "Random" "Param"))
         (short-string-top (list "?" "C" "M" "P!" "Z!" "Opt" "Swt"))    
         (buttons-top (list (send self :plot-help)  (send self :color)
                            (send self :mouse-mode) (send self :pop)
                            (send self :zoom)       (send self :options)
                            (send self :switch)     (send self :new-x) 
                            (send self :new-y)      (send self :new-z) 
                            (send self :box)        (send self :iterate)
                            (send self :undo)       (send self :equate) 
                            (send self :tiles)      (send self :bins) 
                            (send self :smooth)     (send self :normal) 
                            (send self :density)    (send self :connect)
                            (send self :random)     (send self :param)))
         
         (top-bar (send self :setup-redraw-button-bar 
                        string-top buttons-top short-string-top 0)) 
         (lefts (first top-bar))
         (strings (second top-bar))
         (num-top-buttons (length (first top-bar)))
         (string-bot (list "" "BinWidth" "Curves" "Plots" "Data"))
         (short-string-bot (list "" "BW" "Cvs" "Plts" "Data")) 
         (buttons-bot (list (send self :bin2) (send self :bin2) 
                            (send self :curves) (send self :plot)
                            (send self :savedata)))
         (bot-bar (send self :setup-redraw-button-bar string-bot buttons-bot
                        short-string-bot 0)))
    (when (first bot-bar) 
          (setf lefts (combine lefts (first bot-bar)))
          (setf strings (combine strings (second bot-bar))))
    (send self :num-top-buttons (length (first top-bar)))
    (send self :lefts lefts)
    (send self :strings strings)
    (send self :buttons (repeat nil (length strings)))
    (when (and *plot-menu-hot-spot* (send self :hot-spot))
          (send self :pull-down-menu-spots t (send self :new-x) (send self :new-y)))
    ))

(defmeth vista-graph-overlay-proto :setup-redraw-button-bar 
           (slist blist &optional sslist replace-butnum vertical ) 
   (let* ((graph (slot-value 'graph)) (lefts) (strings)
          (width 10) (button-gap 5) (gap 2) (topx 5) (i 0)
          (wlist (mapcar #'(lambda (string)
                             (send graph :text-width string))
                         slist)))
     (mapcar #'(lambda (b-element s-element w-element)
                 (when b-element
                       (setf lefts (add-element-to-list lefts topx))
                       (setf strings (add-element-to-list strings s-element))
                       (setf topx (+ topx width gap w-element button-gap))))
             blist slist wlist)
     (when (and sslist (if vertical
                           (> topx (send graph :canvas-height))
                           (> topx (send graph :canvas-width))))
           (let ((shorterlist slist))
             (setf (select shorterlist replace-butnum) (first sslist))
             (setf results (send self :setup-redraw-button-bar 
                                 shorterlist blist (rest sslist) (1+ REPLACE-BUTNUM)))
             (when (> topx (send graph :canvas-width))
                   (setf lefts (first results))
                   (setf strings (second results))
                   (setf topx (third results)))))
     (list lefts strings topx)))
  
(defmeth vista-graph-overlay-proto :remove-button (button)
"Arg: Button
Removes an installed button. BUTTON is the symbol for the overlay slot controlling the installation of the button. For example (send overlay :remove-button ':box)"
  (send self button nil)
  (send self :setup-redraw)
  (send self :redraw))

(defmeth vista-graph-overlay-proto :install-button (button)
"Arg: BUTTON
Installs button. BUTTON is the symbol for the overlay slot controlling the installation of the button. For example (send overlay :install-button ':box)"
  (send self button t)
  (send self :setup-redraw)
  (send self :redraw))

(provide "overlay1")